// scriptDoc.h : interface of the CScriptDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_SCRIPTDOC_H__B036D137_15EF_11D2_852D_2E9E34000000__INCLUDED_)
#define AFX_SCRIPTDOC_H__B036D137_15EF_11D2_852D_2E9E34000000__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#define IDS_PROGRAMSTRING 1000

extern class COutputWindow *gpOutputWindow;

class CScriptDoc : public CDocument
{
	friend class CScriptApp;
protected: // create from serialization only
	CScriptDoc();
	bool m_bLaunching;
	DECLARE_DYNCREATE(CScriptDoc)

// Attributes
public:

// Operations
public:
	BOOL DoOnOpenDocument(LPCTSTR lpszPathName);
	void DoRunDocument(bool bInitEnvironment);
	void SetDocumentTitle(const TCHAR *lpszPathName);

// Overrides
	BOOL DoPromptFileName(CString& fileName, UINT nIDSTitle, DWORD lFlags, BOOL bOpenFileDialog, CDocTemplate* pTemplate);
	BOOL DoSave(LPCTSTR lpszPathName, BOOL bReplace);

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CScriptDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);
	virtual void DeleteContents();
	virtual void OnChangedViewList();
	virtual void OnCloseDocument();
	//}}AFX_VIRTUAL

#undef _DEBUG // EMP DIKEO

// Implementation
public:
	void ReadFromFile( CFile *pFile, UINT nLen, CString& cstrCode );
	CString m_strCode;
	virtual ~CScriptDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	BOOL EnsureOutputWindowOpen();
//	void ReadFromArchive( CArchive& ar, UINT nLen );

// Generated message map functions
protected:
	void doWriteEncryptedBytesV2( CArchive& ar, const TCHAR *szBuf, UINT nLen, DWORD dwFileFlag );
	void doWriteASCIIBytes( CArchive& ar, const TCHAR *szBuf, UINT nLen );
	void WriteToArchive( CArchive& ar );
	void doDecryptV2( TCHAR *szBuf, UINT nLen, DWORD dwFileFlag );
	DWORD doCalculateChecksum( const TCHAR *szBuf, DWORD dwSeed );
	//{{AFX_MSG(CScriptDoc)
	afx_msg void OnToolRun();
	afx_msg void OnToolsExecutecode();
	afx_msg void OnToolsShowvariable();
	afx_msg void OnToolsContinue();
	afx_msg void OnUpdateToolsContinue(CCmdUI* pCmdUI);
	afx_msg void OnToolsStats();
	afx_msg void OnUpdateFileSaveAs(CCmdUI* pCmdUI);
	afx_msg void OnUpdateToolsExecutecode(CCmdUI* pCmdUI);
	afx_msg void OnUpdateToolsShowvariable(CCmdUI* pCmdUI);
	afx_msg void OnUpdateToolsStats(CCmdUI* pCmdUI);
	afx_msg void OnUpdateToolRun(CCmdUI* pCmdUI);
	afx_msg void OnRunbutton();
	afx_msg void OnUpdateRunbutton(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileSave(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileNew(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileOpen(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileSaveEncrypted(CCmdUI* pCmdUI);
	afx_msg void OnFileSaveEncrypted();
	afx_msg void OnToolsStep();
	afx_msg void OnToolsTrace();
	afx_msg void OnToolsDesigner();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	BOOL isExe;
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SCRIPTDOC_H__B036D137_15EF_11D2_852D_2E9E34000000__INCLUDED_)
